///*****************************************************************************
// Arquivo my_definitions.h - Desenvolvido por Márcio José Soares
// Diretrizes de pré-compilação para módulo principal main
//*****************************************************************************

//*****************************************************************************
// O Copyright deste programa está reservado para MARCIO JOSE SOARES e 
// seu conteúdo está protegido pela lei de Direitos Autorais LEI Nº 9.610,
// de 19 de Fevereiro de 1998. É estritamente proíbida a reprodução total ou
// parcial dos conteúdos aqui apresentados sem a prévia autorização por escrito
// do detentor dos seus direitos.
//*****************************************************************************

#ifndef MY_DEFINES_H
#define	MY_DEFINES_H

//******************************************************************************
// Se nenhuma freqüência foi definida, assume 48MHz (12MHz x 4 PLL)
// Esta definição é exigida para calibrar as funções __delay_us() e __delay_ms()
//******************************************************************************
#ifndef __XTAL_FREQ__
#define _XTAL_FREQ 20000000UL
#endif

//******************************************************************************
// Definições importantes do módulo
//******************************************************************************
#define byte    uint8_t
#define TRUE    1
#define FALSE   1

//******************************************************************************
// usar apenas 1
#define BARRA   21
//#define ANEL    24

#ifdef BARRA
#define QTLEDs  BARRA+1      // a barra de teste tem 8 LEDs
#define LIM0    5//2
#define LIM1    10//4
#define LIM2    15//6
#define LIM3    21//8
#else
#define QTLEDs  ANEL+1      // o anel de teste tem 24 LEDs
#define LIM0    6
#define LIM1    12
#define LIM2    18
#define LIM3    24
#endif

#define TestBit(var, bit)   ((var) & (1 << (bit)))

//*****************************************************************************
// Efeitos
#define     RED             1
#define     GREEN           2
#define     BLUE            3
#define     RAINBOW         4

#define     RED_ON          10
#define     GREEN_ON        11
#define     BLUE_ON         12
#define     RAINBOW_ON      13

#define     RED_BLINK       14
#define     GREEN_BLINK     15
#define     BLUE_BLINK      16
#define     RAINBOW_BLINK   17

#define     RED_WALK        18
#define     GREEN_WALK      19
#define     BLUE_WALK       20
#define     RAINBOW_WALK    21

#define     EFECTS_END      22

#define     ADDREFC         0x00    // endereço para gravar byte do efeito

//*****************************************************************************
// Não há uma função C equivalente, então é preciso usar uma linha em ASM.
// Obs.: Interrupções tipo "pino" podem acordar o PIC, mas ints tipo "timer" não
#define 	sleep() asm("sleep")

// Nao Operador 
#define 	nop()   asm("nop")

//*****************************************************************************
// Configuração para pinos de I/O
//*****************************************************************************
#define IO_PINSET_A		0x00			//portA é saída
#define IO_PINSET_B		0x01			//portB é saída, exceto RB0
#define IO_PINSET_C		0x80			//portC é saída, exceto RC7(Rx)

//******************************************************************************
// Definições dos ports e pinos de I/O genéricos
//******************************************************************************
#define PORTWS      PORTA
#define PWS         0x01

#define PORTKEY     PORTA
#define KEY         0x04

//******************************************************************************
// Definições das macros de controle dos pinos de I/O genéricos
//******************************************************************************
#define WSpinH      LATAbits.LATA0 = 1
#define WSpinL      LATAbits.LATA0 = 0          
#define readKey     (PORTAbits.RA2 == 0)
#endif	/* MY_DEFINES_H */

