//*****************************************************************************
// Arquivo my_eeprom.c - tratamento da EEPROM
// Desenvolvido por Márcio José Soares
//*****************************************************************************

//*****************************************************************************
// O Copyright deste programa está reservado para MARCIO JOSE SOARES e 
// seu conteúdo está protegido pela lei de Direitos Autorais LEI Nº 9.610,
// de 19 de Fevereiro de 1998. É estritamente proíbida a reprodução total ou
// parcial dos conteúdos aqui apresentados sem a prévia autorização por escrito
// do detentor dos seus direitos.
//*****************************************************************************

//******************************************************************************
// Arquivos incluídos no módulo
//******************************************************************************
#include <xc.h>
#include <stdio.h>
#include <stdlib.h>
#include "pic_eeprom.h"
#include "my_defines.h"

//*****************************************************************************
// Definições importantes do módulo
//*****************************************************************************

//*****************************************************************************
// Variáveis locais do módulo
//*****************************************************************************

//*****************************************************************************
// Variáveis externas do módulo
//*****************************************************************************
uint8_t efeito;

//*****************************************************************************
// Funções do módulo
//*****************************************************************************
  
//*****************************************************************************
// Função write_B_eeprom - escreve 1 byte EEPROM
//
// Entradas - byte a escrever e endereço
// Saídas   - nenhuma 
//*****************************************************************************
void write_B_eeprom(byte dado, byte address){

	INTCONbits.GIE = 0;				// impede interrupções
    EEADRL  = address;              // carrega endereço
    EEDATL = dado;					// carrega dado
    
	EECON1bits.CFGS = 0;			// garante CFGS=0 e EEPGD=0
	EECON1bits.EEPGD = 0;
    EECON1bits.WREN = 1;      		// seta bit WREN para habilitar escrita
    
    PIR2bits.EEIF = 0;              // limpa flag da int
    
    EECON2 = 0x55;              	// #1 - sequencia requerida
    EECON2 = 0xaa;              	// #2
    EECON1bits.WR = 1;         		// #3 - inicia escrita
   
    while(EECON1bits.WR){			// aguarda escrever   
		nop();
	}

	EECON1bits.WREN = 0;              // desabilita escrita - reseta WREN
	INTCONbits.GIE = 1;               //habilita ints novamente
	
}

//*****************************************************************************
// Função read_B_EEPROM - lÊ um byte na EEPROM
//
// Entradas - endereço na EEPROM (int16)
// Saídas   - dado lido (byte)
//*****************************************************************************
byte read_B_eeprom(byte address){

  	EEADRL  = address;              //carrega registrador com endereço desejado
	EECON1bits.CFGS = 0;            //garante CFGS=0 e EEPGD=0
	EECON1bits.EEPGD = 0;
    EECON1bits.RD = 1;           	//seta bit RD para ativar leitura
   
	return (EEDATL);                //retorna com dado
}
