'*******************************************************************************
'* Programa tranca_AB2k.BAS
'* Desenvolvido por Mrcio Jos Soares - Arne(www.arnerobotics.com.br)
'*
'* Compilador usado: BASCOM AVR 1.11.9.8 Demo
'*
'* Obs.: Este foi desenvolvido para rodar com o Arne Basic 2k. O uso com
'*       outro microcontrolador fica por conta e risco de cada um!
'*
'* Requer tambm:
'*        1 LCD Serial Arne Robotics;
'*        1 teclado matricial 4x4 Arne Robotics;
'*        1 micro servo
'*        alm de outros componentes (veja o artigo)
'*******************************************************************************

'*******************************************************************************
'Configs necessrios ao microcontrolador
$crystal = 10000000
$regfile = "attiny2313.dat"
Config Com1 = Dummy , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0
$baud = 9600

'*******************************************************************************
'Configura portas
Config Portb = &B00000101               'PortB - PB0, PB2 so sadas o resto entrada
Config Portd = &B11111110               'PortD - sada exceto PD0

'*******************************************************************************
'Configura servo
Config Servos = 1 , Servo1 = PortD.2 , Reload = 10

'*******************************************************************************
'Configura Timer 1 - usado para desligar o back ligth do LCD se nenhuma
'                    tecla for pressionada dentro de 30 segundos
'Timer, modo assincrono, preescale 128
'clock externo 10 MHz
'10MHz / 1024(prescale) = 9.7656kHz => T = 1 / 9.7656kHz = 102.4 us
'102.4 us x 48828 = 500 ms
'entao haver uma int a cada 500 ms
Config Timer1 = Timer , Prescale = 1024
Timer1 = 65535 - 4882                   'valor inicial da contagem

'*******************************************************************************
'Variveis globais
Dim Tec As Byte                         'guarda ltima tecla pressionada
Dim senha(4) as Byte                    'guarda senha digitada
Dim passdec(4) as Byte                  'colhe senha guardada
Dim count_tec as integer                'contador de teclas
Dim count_err as integer                'contador de tentativas
Dim timertec as integer                 'conta tempo sem teclas
Dim tipo as byte                        'tipo da mensagem a ser enviada
Dim Ln as byte                          'nmero da linha no LCD
Dim tempo as byte                       'tempo para buzzer

'*******************************************************************************
'Cdigo armazenados na EEPROM do microcontrolador
'Troque os valores de acordo com a senha desejada
'mypass:
'$eeprom                                 'muda ponto de armazenamento para EEPROM
'Data &H41 , &H31 , &H32 , &H33          'estes bytes sero inseridos na EEPROM
'$data                                   'retorna para FLASH

BUZZER Alias PORTB.0                    'pino de controle do buzzer
SENSOR Alias PINB.1                     'pino de entrada para o sensor
BL_LCD Alias Portb.2                    'pino de controle do BackLigth do LCD
S1 Alias PINB.3                         'chave para abrir a porta
Colunas Alias PortD                     'colunas so sadas
Linhas Alias PinB                       'linhas so entradas

'*******************************************************************************
'Declarao das subrotinas
Declare Sub Msg_ini()
Declare Sub Msg_trab()
Declare Sub Msg_err()
Declare Sub Msg_acess()
Declare Sub Apaga_disp()
Declare Sub MUDA_LINHA()
Declare Sub Varre_teclado()
Declare Sub Show_in()
Declare Sub Make_pass()
Declare Sub Decod_pass()
Declare Sub beep()
Declare Sub abre_porta()
Declare Sub zera_vars()

'*******************************************************************************
'Incio do programa
call zera_vars()

Wait 3                                  'tempo para iniciar sistemas
Printbin &HFE                           'envia comando para LCD
Waitms 10                               'aguarda
Printbin &H07                           'muda velocidade para 19200 no LCD
Waitms 10
Baud = 19200                            'seta novo baud a 19200 bps

set BL_LCD                              'desliga back_ligth
call Msg_ini()                          'msg principal

tempo = 200                             'toca beep inicial
call beep
call beep
call beep

wait 3                                  'espera para mostrar msg

call Msg_trab()                         'mostra msg solicitando senha
wait 1
reset BL_LCD                            'apaga lcd


'*******************************************************************************
'Habilita interrupoes
On TIMER1 MyISR_T1                      'quando houver uma interrupo do timer 1, desvia para MyISR_T1
Enable TIMER1                           'habilita timer 1
Enable Interrupts

Servo(1) = 100                          'posiciona o servo fechado

'*******************************************************************************
'Lao principal
Do

   Tec = 0                              'zera tecla
   Call Varre_teclado()                 'verifica se tem tecla
   If Tec <> 0 Then                     'se diferente de zero tem tecla para capturar
      tempo = 200
      call beep                         'tom de reconhecimento de tecla
      set BL_LCD                        'mantem LCD ligado
      call Show_in()                    'mostra entrada falsa = '*'
      call Make_pass()                  'monta senha
   End If

   if S1 = 0 then                       'chave S1 pressionada
      call abre_porta()                 'abra a porta
      call zera_vars()
     call msg_trab()
   end if

Loop

'*******************************************************************************
'Label para tratamento da interrupo do Timer1
'Usado para desligar o LED do back ligth do LCD
'caso nenhuma tecla seja pressionada dentro de 30 segundos
'Tempo do timer: 500ms
MyISR_T1:

   incr timertec                        'incrementa var que guarda o tempo
   if timertec = 60 then                'se chegou a 30 segundos
      timertec = 0                      'volta valor antetior
      if tec = 0 then                   'nenhuma tecla pressionada?
         reset BL_LCD                   'desliga o back ligth
      endif
   endif

   Timer1 = 65535 - 4882                'retorna valor para nova contagem
   return                               'gera um RETI
   return                               'gera um RET

'*******************************************************************************
'Subrotina para montar e verificar a senha
Sub Make_pass()

   Local i as byte

   senha(count_tec) = Tec               'guarda digito da senha
   count_tec = count_tec + 1            'incrementa contador
   if count_tec = 5 then                'a senha tem 4 digitos - 0 a 3
      call decod_pass()                 'decodifica
      if count_err = 0 then             'senha correta?
         tipo = 1
         call msg_acess                 'avisa acesso permitido
         call abre_porta()              'abre porta
         call zera_vars()               'zera variveis
      endif

      if count_err = 3 then             'nmero de tentativas erradas excedidas?
         count_err = 0
         call Msg_err()                 'mostra msg de erro
         wait 20                        'espera 20 segundos at voltar
      endif

      call Msg_trab()                   'mostra msg solicitando senha

   end if

End Sub

'*******************************************************************************
'Subrotina para decodificar a senha
Sub Decod_pass()

   Local i as byte

   for i = 1 to 4 step 1
      if senha(i) <> passdec(i) then    'se digitos no esto corretos
         tipo = 2
         call msg_acess
         count_tec = 1                  'retorna para inicio para nova entrada
         tempo = 200                    'dispara beep
         call beep
         call beep
         call beep
         wait 2
         incr count_err                 'incrementa nr de tentativas erradas
         exit for                       'sai do lao
      else
         count_err = 0
      end if
   next i

End Sub

'*******************************************************************************
'Subrotina para abrir a porta
Sub abre_porta()

   tempo = 200
   call beep
   call beep
   call beep

   servo(1) = 200                       'abre tranca

   while sensor = 0                     'espera usuario abrir a porta
      call beep
      waitms 300
   wend

   waitms 300

   while sensor = 1                     'aguarda porta ser fechada
      call beep
      waitms 300
   wend

   waitms 500                           'aguarda
   servo(1) = 100                       'porta fechada, volta servo ao estado anterior

End Sub

'*******************************************************************************
'Subrotina para zerar variveis
Sub zera_vars()

   count_tec = 1                        'inicia vars
   count_err = 0
   timertec = 0
   passdec(1) = "A"
   passdec(2) = "1"
   passdec(3) = "2"
   passdec(4) = "3"
   senha(1) = 0
   senha(2) = 0
   senha(3) = 0
   senha(4) = 0

End Sub

'*******************************************************************************
'Subrotina para apagar LCD
Sub Apaga_disp()

   Printbin &HFE                        'coloca LCD em modo comando
   Waitms 10                            'espera processar
   Printbin &H01                        'envia comando
   Waitms 10

End Sub

'*******************************************************************************
'Subrotina para muda de linha no LCD
Sub Muda_linha()

   Printbin &HFE                        'coloca LCD em modo comando
   Waitms 10                            'espera processar

   If Ln = 1 Then                       'se ln  1
      Printbin &H03                     'comando HOME
   Elseif Ln = 2 Then                   'mas se for 2
      Printbin &H02                     'muda para linha 2
   End If

   Waitms 10

End Sub

'*******************************************************************************
'Subrotina para imprimir mensagem de erro no LCD
Sub Msg_err()

   Waitms 100                           'aguarda qualquer processamento anterior
   Call Apaga_disp()                    'apaga display
   Print "Nr de tentativas";            'insere mensagens
   Ln = 2
   Call muda_linha()
   Print "   excedidas!   ";            '

End Sub

'*******************************************************************************
'Subrotina para imprimir mensagem inicial no LCD
Sub Msg_ini()

   Waitms 100                           'aguarda qualquer processamento anterior
   Call Apaga_disp()                    'apaga display
   Print " Tranca uC AB2K";             'insere mensagens

End Sub

'*******************************************************************************
'Subrotina para imprimir mensagem de acesso permitido ou no
Sub Msg_acess()

   Waitms 100                           'aguarda qualquer processamento anterior
   Call Apaga_disp()                    'apaga display
   if tipo = 1 then
      Print " Acesso liberado";         'insere mensagens
   else
      Print " Acesso negado";           'insere mensagens
   end if

End Sub

'*******************************************************************************
'Subrotina para imprimir mensagem no LCD
Sub Msg_trab()

   Waitms 100                           'aguarda qualquer processamento anterior
   Call Apaga_disp()                    'apaga display
   Print " Digite a senha";             'insere mensagens
   Ln = 2
   call Muda_linha()                    'muda para linha 2
   Print "      ";                      'posiciona cursor para senha

End Sub

'*******************************************************************************
'Subrotina para imprimir "*" no LCD
Sub Show_in()

   Waitms 100                           'aguarda qualquer processamento anterior
   Print "*";                           'insere *
   'Printbin Tec;                        'comente a linha acima e descomente essa para ver o caracter digitado no LCD

End Sub

'*******************************************************************************
'Subrotina para tocar o buzzer
Sub beep()

   Local i as byte

   if tempo > 0 then
      for i = 0 to tempo step 1 do
         set buzzer
         waitus 250
         reset buzzer
         waitus 250
      next i
   end if

   reset buzzer

End sub

'*******************************************************************************
'Subrotina para fazer a varredura do teclado
'Arrume a disposio das teclas conforme a sua necessidade ok! ;-)
Sub Varre_teclado()

   Local Mylinhere As Byte
   Local Aux As Byte

   Aux = &HF7                           '11110111
   Colunas = Colunas or &HF8            'liga todos os pinos das colunas
   Colunas = Colunas And Aux            'zero na primeira coluna
   Waitms 10                            'espera alguns ms
   Mylinhere = Linhas And &HF0
   If Mylinhere <> &HF0 Then            'se diferente do estado default
      Select Case Mylinhere
         Case &HE0 : Tec = "1"          'pressionou S1 - 1
         Case &HD0 : Tec = "4"          'pressionou S5 - 4
         Case &HB0 : Tec = "7"          'pressionou S9 - 7
         Case &H70 : Tec = "*"          'pressionou S13 - *
      End Select
   End If

   Aux = &HEF                           '11101111
   Colunas = Colunas or &HF8            'liga todos os pinos das colunas
   Colunas = Colunas And Aux            'zero na segunda coluna
   Waitms 10                            'espera alguns ms
   Mylinhere = Linhas And &HF0;         'l as linhas e limpa
   If Mylinhere <> &HF0 Then            'se diferente do estado default
      Select Case Mylinhere
         Case &HE0 : Tec = "2"          'pressionou S2  - 2
         Case &HD0 : Tec = "5"          'pressionou S6  - 5
         Case &HB0 : Tec = "8"          'pressionou S10 - 8
         Case &H70 : Tec = "0"          'pressionou S14 - 0
      End Select
   End If

   Aux = &HDF                           '11011111
   Colunas = Colunas or &HF8            'liga todos os pinos das colunas
   Colunas = Colunas And Aux            'zero na terceira coluna
   Waitms 10                            'espera alguns ms
   Mylinhere = Linhas And &HF0;         'l as linhas e limpa
   If Mylinhere <> &HF0 Then            'se diferente do estado default
      Select Case Mylinhere
         Case &HE0 : Tec = "3"          'pressionou S3  - 3
         Case &HD0 : Tec = "6"          'pressionou S7  - 6
         Case &HB0 : Tec = "9"          'pressionou S11 - 9
         Case &H70 : Tec = "#"          'pressionou S15 - #
      End Select
   End If

   Aux = &HBF                           '1011111
   Colunas = Colunas or &HF8            'liga todos os pinos das colunas
   Colunas = Colunas And Aux            'zero na ltima coluna
   Waitms 10                            'espera alguns ms
   Mylinhere = Linhas And &HF0;         'l as linhas e limpa
   If Mylinhere <> &HF0 Then            'se diferente do estado default
      Select Case Mylinhere
         Case &HE0 : Tec = "A"          'pressionou S4  - A
         Case &HD0 : Tec = "B"          'pressionou S8  - B
         Case &HB0 : Tec = "C"          'pressionou S12 - C
         Case &H70 : Tec = "D"          'pressionou S16 - D
      End Select
   End If


End Sub

End                                     'final do programa